/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.events;

import com.cisco.pt.impl.IPCEventLTV;
import com.cisco.pt.ipc.enums.ModuleType;
import com.cisco.pt.ipc.events.IPCEvent;

public abstract class DeviceEvent
extends IPCEvent {
    public EventType type;

    public DeviceEvent(IPCEventLTV ltv) {
        super(ltv);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EventType {
        NAME_CHANGED,
        POWER_CHANGED,
        MODULE_ADDED,
        MODULE_REMOVED,
        PORT_ADDED,
        PORT_REMOVED;

    }

    public static class PortRemoved
    extends DeviceEvent {
        public String portName;

        public PortRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PORT_REMOVED;
            this.portName = (String)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tportName = " + this.portName;
        }
    }

    public static class PortAdded
    extends DeviceEvent {
        public String portName;

        public PortAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.PORT_ADDED;
            this.portName = (String)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\tportName = " + this.portName;
        }
    }

    public static class ModuleRemoved
    extends DeviceEvent {
        public ModuleType inType;
        public String model;

        public ModuleRemoved(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MODULE_REMOVED;
            this.inType = ModuleType.fromIntValue((Integer)ltv.getEventParameters().get(0));
            this.model = (String)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tinType = " + (Object)((Object)this.inType) + "\n\tmodel = " + this.model;
        }
    }

    public static class ModuleAdded
    extends DeviceEvent {
        public ModuleType inType;
        public String model;

        public ModuleAdded(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.MODULE_ADDED;
            this.inType = ModuleType.fromIntValue((Integer)ltv.getEventParameters().get(0));
            this.model = (String)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tinType = " + (Object)((Object)this.inType) + "\n\tmodel = " + this.model;
        }
    }

    public static class PowerChanged
    extends DeviceEvent {
        public Boolean on;

        public PowerChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.POWER_CHANGED;
            this.on = (Boolean)ltv.getEventParameters().get(0);
        }

        public String toString() {
            return super.toString() + "\n\ton = " + this.on;
        }
    }

    public static class NameChanged
    extends DeviceEvent {
        public String newName;
        public String oldName;

        public NameChanged(IPCEventLTV ltv) {
            super(ltv);
            this.type = EventType.NAME_CHANGED;
            this.newName = (String)ltv.getEventParameters().get(0);
            this.oldName = (String)ltv.getEventParameters().get(1);
        }

        public String toString() {
            return super.toString() + "\n\tnewName = " + this.newName + "\n\toldName = " + this.oldName;
        }
    }
}

